#include <Arduino_APDS9960.h>

#include <U8g2lib.h>
#include <Wire.h>
int light=8;
int fan=9;

U8G2_SSD1306_128X64_NONAME_F_HW_I2C u8g2(U8G2_R0, /* reset=*/ U8X8_PIN_NONE);

void setup() {
  Serial.begin(9600);
 
 u8g2.begin();
 u8g2.setFont(u8g2_font_pxplusibmvga9_tf);

  if (!APDS.begin()) {
    Serial.println("Error initializing APDS9960 sensor!");
  }

  // for setGestureSensitivity(..) a value between 1 and 100 is required.
  // Higher values makes the gesture recognition more sensible but less accurate
  // (a wrong gesture may be detected). Lower values makes the gesture recognition
  // more accurate but less sensible (some gestures may be missed).
  // Default is 80
  //APDS.setGestureSensitivity(80);

  Serial.println("Detecting gestures ...");
   pinMode(light,1);
  pinMode(fan,1);
}
void loop() {
  if (APDS.gestureAvailable()) {
    // a gesture was detected, read and print to serial monitor
     u8g2.clearBuffer();
    int gesture = APDS.readGesture();

    switch (gesture) {
      case GESTURE_UP:
     
         digitalWrite(light,1);
        Serial.println("Detected UP gesture");
         u8g2.setFontDirection(1);
         u8g2.setFont(u8g2_font_pxplusibmvga9_tf);
 
         u8g2.setCursor(110, 10);
         u8g2.println("Lights"); 
        
         u8g2.setCursor(95, 30);
         u8g2.println("on");
       
         u8g2.setFont(u8g2_font_open_iconic_all_4x_t);
         u8g2.drawGlyph(60,40, 118); 

         u8g2.drawGlyph(20,30, 196); 
     
         u8g2.sendBuffer();
        
        break;

      case GESTURE_DOWN:
         digitalWrite(light,1);
        Serial.println("Detected DOWN gesture");
         u8g2.setFont(u8g2_font_pxplusibmvga9_tf);
 
         u8g2.setCursor(110, 10);
         u8g2.println("Lights"); 
        
         u8g2.setCursor(95, 30);
         u8g2.println("off");
       
         u8g2.setFont(u8g2_font_open_iconic_all_4x_t);
         u8g2.drawGlyph(60,40, 117); 

         u8g2.drawGlyph(20,30, 196); 
         u8g2.sendBuffer();
         
        break;

      case GESTURE_LEFT:

         digitalWrite(fan,1);
          u8g2.setFont(u8g2_font_pxplusibmvga9_tf);
 
         u8g2.setCursor(110, 10);
         u8g2.println("Fan"); 
        
         u8g2.setCursor(95, 30);
         u8g2.println("on");
       
         u8g2.setFont(u8g2_font_open_iconic_all_4x_t);
         u8g2.drawGlyph(60,30, 119); 

         u8g2.drawGlyph(20,30, 84); 
         u8g2.sendBuffer();
        break;

      case GESTURE_RIGHT:

          digitalWrite(fan,0);
         u8g2.setFont(u8g2_font_pxplusibmvga9_tf);
 
         u8g2.setCursor(110, 10);
         u8g2.println("Fan"); 
        
         u8g2.setCursor(95, 30);
         u8g2.println("off");
       
         u8g2.setFont(u8g2_font_open_iconic_all_4x_t);
         u8g2.drawGlyph(60,30, 116); 

         u8g2.drawGlyph(20,30, 84); 
         u8g2.sendBuffer();
        break;

      default:
      
        break;
        
    }}}
